/*==================================================*
 $Id: sr-slideshow, v 2.10 2009/08/27 $
 Copyright 2005 Rudolf Sedlaczek 
 $Id: slideshow.js,v 1.16 2003/10/14 12:39:00 pat Exp $
 Copyright 2000-2003 Patrick Fitzgerald
 http://slideshow.barelyfitz.com/
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 *==================================================*/

// There are two objects defined in this file:
// "slide" - contains all the information for a single slide
// "slideshow" - consists of multiple slide objects and runs the slideshow

//==================================================
// slide object
//==================================================
function slide(src,link,text,target,attr,width,height) {
  // This is the constructor function for the slide object.
  // It is called automatically when you create a new slide object.
  // For example:
  // s = new slide();

  // Image URL
  this.src = src;

  // Link URL
  this.link = link;

  // Text to display
  this.text = text;

  // Name of the target window ("_blank")
  this.target = target;

  // Custom duration for the slide, in milliseconds.
  // This is an optional parameter.
  // this.timeout = 3000

  // Attributes for the target window:
  // width=n,height=n,resizable=yes or no,scrollbars=yes or no,
  // toolbar=yes or no,location=yes or no,directories=yes or no,
  // status=yes or no,menubar=yes or no,copyhistory=yes or no
  // Example: "width=200,height=300"
  this.attr = attr;

  // display-width of image 
  this.width= width;

  // display-height of image 
  this.height= height;


  // Create an image object for the slide
  if (document.images) {
    this.image = new Image();
  }

  // Flag to tell when load() has already been called
  this.loaded = false;

  //--------------------------------------------------
  this.load = function() {
    // This method loads the image for the slide

    if (!document.images) { return; }

    if (!this.loaded) {
      this.image.src = this.src;
      this.loaded = true;
    }
  }

  //--------------------------------------------------
  this.hotlink = function() {
    // This method jumps to the slide's link.
    // If a window was specified for the slide, then it opens a new window.

    var mywindow;

    // If this slide does not have a link, do nothing
    if (!this.link) return;

    // Open the link in a separate window?
    if (this.target) {

      // If window attributes are specified,
      // use them to open the new window
      if (this.attr) {
        mywindow = window.open(this.link, this.target, this.attr);
  
      } else {
        // If window attributes are not specified, do not use them
        // (this will copy the attributes from the originating window)
        mywindow = window.open(this.link, this.target);
      }

      // Pop the window to the front
      if (mywindow && mywindow.focus) mywindow.focus();

    } else {
      // Open the link in the current window
      location.href = this.link;
    }
  }
}

//==================================================
// slideshow object
//==================================================
function slideshow( slideshowname ) {
  // This is the constructor function for the slideshow object.
  // It is called automatically when you create a new object.
  // For example:
  // ss = new slideshow("ss");

  // Name of this object
  // (required if you want your slideshow to auto-play)
  // For example, "SLIDES1"
  this.name = slideshowname;

  // When we reach the last slide, should we loop around to start the
  // slideshow again?
  this.repeat = true;

  // Number of images to pre-fetch.
  // -1 = preload all images.
  //  0 = load each image is it is used.
  //  n = pre-fetch n images ahead of the current image.
  // I recommend preloading all images unless you have large
  // images, or a large amount of images.
  this.prefetch = 1;

  // name-tag of IMAGE element on your HTML page.
  // For example, document.images.SLIDES1IMG
  this.image;

  // ID of a DIV element on your HTML page that will contain the text.
  // For example, "slides2text"
  // Note: after you set this variable, you should call
  // the update() method to update the slideshow display.
  this.textid;

  // TEXTAREA element on your HTML page.
  // For example, document.SLIDES1FORM.SLIDES1TEXT
  // This is a depracated method for displaying the text,
  // but you might want to supply it for older browsers.
  this.textarea;

  // Milliseconds to pause between slides.
  // Individual slides can override this.
  this.timeout = 5000;

  // Hook functions to be called before and after updating the slide
  // this.pre_update_hook = function() { }
  this.post_update_hook = function() { 
  document.getElementById("counter").innerHTML = this.current + 1 + " / " + this.slides.length
  }

  // These are private variables
  this.slides = new Array();
  this.current = 0;
  this.timeoutid = 0;
  this.thumbsLoaded = 0;
  this.dimShow = 0;

  //--------------------------------------------------
  // Public methods
  //--------------------------------------------------
  this.add_slide = function(slide) {
    // Add a slide to the slideshow.
    // For example:
    // SLIDES1.add_slide(new slide("s1.jpg", "link.html"))
  
    var i = this.slides.length;
  
    // Prefetch the slide image if necessary
    if (this.prefetch == -1) {
      slide.load();
    }

    this.slides[i] = slide;
  }

  //--------------------------------------------------
  this.play = function(timeout) {
    // This method implements the automatically running slideshow.
    // If you specify the "timeout" argument, then a new default
    // timeout will be set for the slideshow.
  
    // Make sure we're not already playing
    if (this.timeoutid != 0) {
      clearTimeout(this.timeoutid);
      this.timeoutid = 0;
    }
  
    // If the timeout argument was specified (optional)
    // then make it the new default
    if (timeout) {
      this.timeout = timeout;
    }
    document.getElementById("pauseButton").style.visibility = "";
	  document.getElementById("pauseButton").width = 24;
    document.getElementById("runButton").style.visibility = "hidden";
	  document.getElementById("runButton").width = 0;

  
    // If the current slide has a custom timeout, use it;
    // otherwise use the default timeout
    if (typeof this.slides[ this.current ].timeout != 'undefined') {
      timeout = this.slides[ this.current ].timeout;
    } else {
      timeout = this.timeout;
    }

    // After the timeout, call this.loop()
    this.timeoutid = setTimeout( this.name + ".loop()", timeout);
  }

  //--------------------------------------------------
  this.pause = function() {
    // This method stops the slideshow if it is automatically running.
  
      document.getElementById("pauseButton").style.visibility = "hidden";
	  document.getElementById("pauseButton").width = 0;
      document.getElementById("runButton").style.visibility = "";
	  document.getElementById("runButton").width = 24;
	  
    if (this.timeoutid != 0) {
      clearTimeout(this.timeoutid);
      this.timeoutid = 0;
    }
  }

  //--------------------------------------------------
  this.update = function() {
    // This method updates the slideshow image on the page

    // Make sure the slideshow has been initialized correctly
    if (! this.valid_image()) { return; }
  
    // Call the pre-update hook function if one was specified
    if (typeof this.pre_update_hook == 'function') {
      this.pre_update_hook();
    }

    // Convenience variable for the current slide
    var slide = this.slides[ this.current ];

    // Determine if the browser supports filters
    var dofilter = false;
    if (this.image &&
        typeof this.image.filters != 'undefined' &&
        typeof this.image.filters[0] != 'undefined' && 
       // only apply filter if in slideshow mode 
       document.getElementById("slideWindow").style.display == "block") {

      dofilter = true;

    }

    // Load the slide image if necessary
    slide.load();
  
    // Apply the filters for the image transition
    if (dofilter) {

      // If the user has specified a custom filter for this slide,
      // then set it now
      if (slide.filter &&
          this.image.style &&
          this.image.style.filter) {

        this.image.style.filter = slide.filter;
      }
      this.image.filters[0].Apply();
    }
    
    // Update the image.
    this.image.src = slide.image.src;
    
    // Update the text
    this.display_text();

    // set slideshow visible, thumbs invisible
    document.getElementById("contact").style.display = "none";
    document.getElementById("legend").style.visibility = "visible";
    document.getElementById("slideWindow").style.display = "block";

    // set width & height
	  this.doResize();
	
    // Play the image transition filters
    if (dofilter) {
      this.image.filters[0].Play();
    }
    
    // Call the post-update hook function if one was specified
    if (typeof this.post_update_hook == 'function') {
      this.post_update_hook();
    }
    
    // Set Button visibility
    if (this.current == 0) {
      document.getElementById("firstButton").style.visibility = "hidden";
      document.getElementById("prevButton").style.visibility = "hidden";
      document.getElementById("forwButton").style.visibility = "";
      document.getElementById("lastButton").style.visibility = "";
      document.getElementById("runButton").style.visibility = "";
    }  
    else if (this.current < this.slides.length - 1) {
      document.getElementById("firstButton").style.visibility = "";
      document.getElementById("prevButton").style.visibility = "";
      document.getElementById("forwButton").style.visibility = "";
      document.getElementById("lastButton").style.visibility = "";
      document.getElementById("runButton").style.visibility = "";
    } 
    else {
      document.getElementById("firstButton").style.visibility = "";
      document.getElementById("prevButton").style.visibility = "";
      document.getElementById("forwButton").style.visibility = "hidden";
      document.getElementById("lastButton").style.visibility = "hidden";
      document.getElementById("runButton").style.visibility = "hidden";
    }
    
    // Do we need to pre-fetch images?
    if (this.prefetch > 0) {

      var next, count;
      // var prev;
      
      // Pre-fetch the next slide image(s)
      next = this.current;
      //prev = this.current;
      count = 0;
      do {

        // Get the next and previous slide number
        // Loop past the ends of the slideshow if necessary
        if (++next >= this.slides.length) next = 0;
        //if (--prev < 0) prev = this.slides.length - 1;

        // Preload the slide image
        this.slides[next].load();
        //this.slides[prev].load();

        // Keep going until we have fetched
        // the designated number of slides
      } while (++count < this.prefetch);
    }
  }

  //--------------------------------------------------
  this.goto_slide = function(n) {
    // This method jumpts to the slide number you specify.
    // If you use slide number -1, then it jumps to the last slide.
    // You can use this to make links that go to a specific slide,
    // or to go to the beginning or end of the slideshow.
    // Examples:
    // onClick="myslides.goto_slide(0)"
    // onClick="myslides.goto_slide(-1)"
    // onClick="myslides.goto_slide(5)"
  
   this.pause();
   if (n == -1) {
      n = this.slides.length - 1;
    }
    if (n < this.slides.length && n >= 0) {
      this.current = n;
    }
    this.update();
  }
  
  //--------------------------------------------------
  this.skip = function(n) {
    // This method advances the number of slides  you specify.
    // Examples:
    // onClick="myslides.skip(-10)"
    // onClick="myslides.skip(5)"
  
    this.pause();
    // Increment/decrement the image number
    this.current = this.current + n;
    // keep in range
    if (this.current >= this.slides.length) {
      this.current = this.slides.length - 1;
	  }
    if (this.current < 0) {
      this.current = 0;
	  }
	this.update();
  }
 
  //--------------------------------------------------
  this.next = function() {
    // This method advances to the next slide.

    this.pause();
    // Increment the image number
    if (this.current < this.slides.length - 1) {
      this.current++;
    } else if (this.repeat) {
      this.current = 0;
    }
    this.update();
  }

  //--------------------------------------------------
  this.previous = function() {
    // This method goes to the previous slide.
  
    this.pause();
    // Decrement the image number
    if (this.current > 0) {
      this.current--;
    } else if (this.repeat) {
      this.current = this.slides.length - 1;
    }
    this.update();
  }
 
   //--------------------------------------------------
  this.display_text = function(text) {
    // Display the text for the current slide
  
    // If the "text" arg was not supplied (usually it isn't),
    // get the text from the slideshow
    if (!text) {
      text = this.slides[ this.current ].text;
    }
  
    // If a textarea has been specified,
    // then change the text displayed in it
    if (this.textarea && typeof this.textarea.value != 'undefined') {
      this.textarea.value = text;
    }

    // If a text id has been specified,
    // then change the contents of the HTML element
    if (this.textid) {

      r = this.getElementById(this.textid);
      if (!r) { return false; }
      if (typeof r.innerHTML == 'undefined') { return false; }

      // Update the text
      r.innerHTML = text;
    }
  }

  //--------------------------------------------------
  this.hotlink = function() {
    // This method calls the hotlink() method for the current slide.
  
    this.slides[ this.current ].hotlink();
  }

  //--------------------------------------------------
  this.save_position = function(cookiename) {
    // Saves the position of the slideshow in a cookie,
    // so when you return to this page, the position in the slideshow
    // won't be lost.
  
    if (!cookiename) {
      cookiename = this.name + '_slideshow';
    }
    document.cookie = cookiename + '=' + this.current;
  }

  //--------------------------------------------------
  this.restore_position = function(cookiename) {
	  // If you previously called slideshow_save_position(),
	  // returns the slideshow to the previous state.
  
    //Get cookie code by Shelley Powers
  
    if (!cookiename) {
      cookiename = this.name + '_slideshow';
    }
  
    var search = cookiename + "=";
  
    if (document.cookie.length > 0) {
      offset = document.cookie.indexOf(search);
      // if cookie exists
      if (offset != -1) { 
        offset += search.length;
        // set index of beginning of value
        end = document.cookie.indexOf(";", offset);
        // set index of end of cookie value
        if (end == -1) end = document.cookie.length;
        this.current = parseInt(unescape(document.cookie.substring(offset, end)));
        }
     }
  }

  //--------------------------------------------------
  this.doResize = function() {
  // resizes the image proportionally
    var clientWidth = Fensterweite();
    var clientHeight = Fensterhoehe() - 50;
    var cx = this.slides[ this.current ].width;
    var cy = this.slides[ this.current ].height;

    if (cx <= 0) {
    cx  = this.image.width
    }
    if (cy <= 0) {
    cy  = this.image.height
    }
   
    if (clientWidth < cx) {
        cy = cy * clientWidth / cx;
        cx = clientWidth
    }
    if (clientHeight < cy) {
        cx = cx * clientHeight / cy;
        cy = clientHeight
    }
    this.image.width = cx;
    this.image.height = cy;
    if (this.dimShow) {
      document.getElementById("looper").innerHTML = Fensterweite() + "x" + Fensterhoehe();
	  }
  }

  //--------------------------------------------------
  this.dimshowToggle = function() {
		this.dimShow = !this.dimShow;
		if (this.dimShow) {
      document.getElementById("looper").innerHTML = Fensterweite() + "x" + Fensterhoehe();
		} else {
      document.getElementById("looper").innerHTML = "";
      if (this.repeat) {
        document.getElementById("looper").innerHTML = "Loop";
      }
		} 
  }
  
  //--------------------------------------------------
  this.thumbs = function() {
		this.pause();
		
		if ( this.thumbsLoaded == 0) {
			this.display_text("Loading thumbnails...");
			var xThumb = Math.floor((Fensterweite() - 30) / 110);
			var contactText = "<table border=0 style=\"overflow-y: auto\">";
			for (i = 0 ; i < this.slides.length / xThumb; i++) 
			{
		    contactText += "<tr height=110 align=center>";
		    for (j = 0; j < xThumb ; j++)
		    {
		       var x = (i * xThumb + j);
		       if (x < this.slides.length) {
		          contactText += "<td width=110><img onclick=" + this.name + ".goto_slide(" + x + ") onMouseover=" + this.name + ".txt(" + x + ") style=\"cursor:pointer;\" src=\"" + vThumb[x] + "\"></td>";
		       }
		    }
		    contactText += "</tr>";
			}
			contactText +=  "</table>";
			contact.innerHTML = contactText;
			this.thumbsLoaded = x;
			this.display_text("Loading done");
		}
		document.getElementById("contact").style.display = "block";
		document.getElementById("slideWindow").style.display = "none";
  }

  //--------------------------------------------------
  this.txt = function(x) {
	  // displays the text in index-mode
	  // x is the number of the image
	  // If a text id has been specified,
	  // then change the contents of the HTML element
		text = "";
    if (typeof x != 'undefined') text = this.slides[x].text;
    
    if (this.textid) {
      r = this.getElementById(this.textid);
      if (!r) { return false; }
      if (typeof r.innerHTML == 'undefined') { return false; }

      // Update the text
      r.innerHTML = text;
    }
  }
  
  //--------------------------------------------------
  this.loopToggle = function() {
	  // toggles Loop mode on/off
	  // display status 
    this.repeat = !this.repeat;
	if (this.repeat) {
      document.getElementById("looper").innerHTML = "Loop";
    }
    else {
      document.getElementById("looper").innerHTML = "";
    }  
  }
  
 //--------------------------------------------------
  this.setdelay = function(delay) {
	  // changes timeout from 0 to 9 sec
	  // display status 
    if (delay >= 0 && delay <= 9000) {
      document.getElementById("counter").innerHTML = "Dauer: " + delay/1000 + " Sek"
      this.timeout = delay;
    }
  }

  //--------------------------------------------------
  this.noscript = function() {
    // This method is not for use as part of your slideshow,
    // but you can call it to get a plain HTML version of the slideshow
    // images and text.
    // You should copy the HTML and put it within a NOSCRIPT element, to
    // give non-javascript browsers access to your slideshow information.
    // This also ensures that your slideshow text and images are indexed
    // by search engines.
  
    $html = "\n";
  
    // Loop through all the slides in the slideshow
    for (i=0; i < this.slides.length; i++) {
  
      slide = this.slides[i];
  
      $html += '<p>';
 
      if (slide.text) {
        $html += slide.text + "<br>\n";
      }
 
      if (slide.link) {
        $html += '<a href="' + slide.link + '">';
      }
  
      $html += '<img src="' + slide.src + '" alt=" ';
      if (slide.text) {
        $html += slide.text;
      }
      $html +=' ">';
  
      if (slide.link) {
        $html += "<\/a>";
      }
 
      $html += "<\/p>" + "\n\n";
    }
  
    // Make the HTML browser-safe
    $html = $html.replace(/\&/g, "&amp;" );
    $html = $html.replace(/</g, "&lt;" );
    $html = $html.replace(/>/g, "&gt;" );
  
    return('<pre>' + $html + '</pre>');
  }

  //==================================================
  // Private methods
  //==================================================

  //--------------------------------------------------
  this.loop = function() {
    // This method is for internal use only.
    // This method gets called automatically by a JavaScript timeout.
    // It advances to the next slide, then sets the next timeout.
    // If the next slide image has not completed loading yet,
    // then do not advance to the next slide yet.

    // Make sure the next slide image has finished loading
    if (this.current < this.slides.length - 1) {
      next_slide = this.slides[this.current + 1];
      if (next_slide.image.complete == null || next_slide.image.complete) {
        this.next();
      }
    } else { // we're at the last slide
      this.next();
    }
    
    // Keep playing the slideshow
    this.play();
  }


  //--------------------------------------------------
  this.valid_image = function() {
    // Returns 1 if a valid image has been set for the slideshow
  
    if (!this.image)
    {
      return false;
    }
    else {
      return true;
    }
  }

  //--------------------------------------------------
  this.getElementById = function(element_id) {
    // This method returns the element corresponding to the id

    if (document.getElementById) {
      return document.getElementById(element_id);
    }
    else if (document.all) {
      return document.all[element_id];
    }
    else if (document.layers) {
      return document.layers[element_id];
    } else {
      return undefined;
    }
  }
}

//==================================================
// General functions
//==================================================
function Fensterweite () {
  if (document.body && document.body.clientWidth) {
  	return document.body.clientWidth;
  } 
  else if (window.innerWidth) {
    return window.innerWidth;
  } 
  else if (document.body && document.body.offsetWidth) {
    return document.body.offsetWidth;
  } 
  else {
    return 0;
  }
}

//==================================================
function Fensterhoehe () {
  if (document.body && document.body.clientHeight) {
  	return document.body.clientHeight;
  } 
  else if (window.innerHeight) {
    return window.innerHeight;
  } 
  else if (document.body && document.body.offsetHeight) {
    return document.body.offsetHeight;
  } 
  else {
    return 0;
  }
}

//==================================================
// trims whitespace from front and end of string
function trim(stringToTrim) {
	return stringToTrim.replace(/^\s+|\s+$/g,"");
}

//==================================================
function neuAufbau () {
  SLIDES.doResize();
}

//==================================================
function exitButton() {

  // fullscreen names: Top in IE, fullWindow in Firefox
  if ( window.name == "Top" || window.name == "fullWindow") {  
    //alert("Window.name ='" + window.name +"'\n Referrer="+document.referrer);
  	window.parent.close();
  }   
  else
  if ( document.referrer.search(/^http:\/\/vms.tuwien.ac.at/i) == -1) {
	//alert ("Referrer: "+document.referrer);
	window.location.href = "../";
  }
  else {
    //alert("call history.back \n Referrer="+document.referrer);
    history.back();
  }   
}

//==================================================
function keyDown(Ereignis) {
  // keycode handler
  
  // get keycode for  Mozilla and IE 
  if (!Ereignis) Ereignis = window.event;
  if (Ereignis.which) {
    Code = Ereignis.which;
  } 
  else if (Ereignis.keyCode) {
    Code = Ereignis.keyCode;
  }
   
  if (88 == Code) {   // x      
    exitButton();
  } 
  else if (37 == Code || 80 == Code || 33 == Code || 8 == Code) { // Left, p, Screen Up, Backspace
    SLIDES.previous();
  }
  else if (39 == Code || 78 == Code || 34 == Code || 13 == Code) { // Right, n, Screen Down, Enter
    SLIDES.next();
  }
  else if (32 == Code || 19 == Code) { // Blank, Pause
    if  (pauseButton.width > 0)  { // Slideshow is running
      SLIDES.pause();
	 	}
    else {
		  SLIDES.next(); 
	 	  SLIDES.play();
	 	}
  }
  else if (36 == Code  || 84 == Code) { // Pos1, t
    SLIDES.goto_slide(0);
  }
  else if (35 == Code  || 66 == Code) { // Ende, b
    SLIDES.goto_slide(-1);
  }
  else if (45 == Code  || 109 == Code || 189 == Code) { // Einf, - 
    SLIDES.skip(-10);
  }
  else if (46 == Code  || 107 == Code || 187 == Code) { // Entf, + 
		SLIDES.skip(10);
  }
  else if (83 == Code) { // s
	 	SLIDES.update();
  }
  else if (73 == Code) { // i
    SLIDES.thumbs();
  }
  else if (72 == Code) { // w + h
    if (SLIDES.dimShow) {
	noscript.innerHTML = SLIDES.noscript();
    }
  }
  else if (76 == Code) { //  l 
    SLIDES.loopToggle();
  }
  else if (87 == Code) { //  w
    SLIDES.dimshowToggle();
  }
  else if (49 == Code) { //  1
    SLIDES.setdelay(1000);
  }
  else if (50 == Code) { //  2
    SLIDES.setdelay(2000);
  }
  else if (51 == Code) { //  3
    SLIDES.setdelay(3000);
  }
  else if (52 == Code) { //  4
    SLIDES.setdelay(4000);
  }
  else if (53 == Code) { //  5
    SLIDES.setdelay(5000);
  }
  else if (54 == Code) { //  6
    SLIDES.setdelay(6000);
  }
  else if (55 == Code) { //  7
    SLIDES.setdelay(7000);
  }
  else if (56 == Code) { //  8
    SLIDES.setdelay(8000);
  }
  else if (57 == Code) { //  9
    SLIDES.setdelay(9000);
  }
  else if (48 == Code) { //  0
    SLIDES.setdelay(0);
  }
 else if (27 == Code && (window.name == "Top" || window.name == "fullWindow") ) {   // Esc
    // Escape only in Fullscreen mode.     
    exitButton();
  } 
}
//==================================================

// create instance of slide object:
SLIDES = new slideshow("SLIDES");
SLIDES.timeout = 5000;
SLIDES.prefetch = 1;
SLIDES.repeat = false;
SLIDES.dimShow = 0;

// load images and attributes 
i = 0;
do {
s = new slide();
s.src =  vImage[i];
if (typeof vText[i] == 'undefined'  || trim(vText[i]) == '') {
  s.text = "&nbsp;";
  }
else {s.text = vText[i];
  }
if (s.text == 'undefined') {
  s.text = "&nbsp;";
  }
s.link = "";
s.target = "";
s.attr = "";
s.filter = "";

if (typeof cxImage == 'undefined') {
  s.width = 0; 
  }
else {
  s.width = cxImage[i];
  }
  
if (s.width == 0) {
  s.width = xImageDef;
  }
   
if (typeof cyImage == 'undefined') {
  s.height = 0; 
  }
else {
  s.height = cyImage[i];
  }

if (s.height == 0) {
  s.height = yImageDef;
  }

SLIDES.add_slide(s);
} while (++i < vImage.length )
